
Type TBodyFactory

	' rectangles	
	rem
	bbdoc: create a body with moment of interia of a rectangle.
	physics is optional and if not null this body will be added
	to the physics engine upon creation.
	end rem
	Function CreateRectangleBody:TBody(physics:TPhysicsSimulator, width:Float, height:Float, mass:Float)
		Local body:TBody = New TBody
		body.SetMass(mass) 
		body.SetMomentOfInertia(mass * (width * width + height * height) / 12)
		If physics <> Null Then
			physics.AddBody(body)
		End If
		Return body
	End Function
	
	'circles	
	rem
	bbdoc: create a body with the moment of inertia of a circle
	physics is optional and if not null this body will be added
	to the physics engine upon creation.
	end rem
	Function CreateCircleBody:TBody(physics:TPhysicsSimulator, radius:Float, mass:Float)
		Local body:TBody = New TBody
		body.SetMass(mass) 
		body.SetMomentOfInertia(.5 * mass * (radius ^ 2))
		If physics <> Null Then
			physics.AddBody(body)
		End If
		Return body
	End Function
	
	rem
	bbdoc:Creates a Body.  The moment of inertia of the body is calculated from the
	set of vertices passed in to this method. The vertices should represent a polygon.
	physics is optional and if not null this body will be added
	to the physics engine upon creation.
	end rem
	Function CreatePolygonBody:TBody(physics:TPhysicsSimulator, vertices:TVertices, mass:Float)
		Local body:TBody = New TBody
		body.SetMass(mass) 
		body.SetMomentOfInertia(mass * vertices.GetMomentOfInertia()) 
		body.SetPosition(vertices.GetCentroid())
		If physics <> Null Then
			physics.AddBody(body)
		End If
		Return body
	End Function
	
	'misc
	rem
	bbdoc: create a body with a custom moment of inertia
	physics is optional and if not null this body will be added
	to the physics engine upon creation.
	end rem
	Function CreateBody:TBody(physics:TPhysicsSimulator, mass:Float, momentOfInertia:Float)
		Local body:TBody = New TBody
		body.SetMass(mass) 
		body.SetMomentOfInertia(momentOfInertia)
		If physics <> Null Then
			physics.AddBody(body)
		End If
		Return body
	End Function
	
	rem
	bbdoc: given a body, this will create an exact copy of it.
	physics is optional and if not null this body will be added
	to the physics engine upon creation.
	end rem
	Function CloneBody:TBody(physics:TPhysicsSimulator, body:TBody)
		Local bodyClone:TBody = TBody.CloneBody(body)
		If physics <> Null Then
			physics.AddBody(bodyClone)
		End If
		Return bodyClone
	End Function
	
	rem
	bbdoc: moment of inertia for a rectangle body.
	end rem
	Function MOIForRectangle:Float(width:Float, height:Float, mass:Float) 
		Return mass * (width * width + height * height) / 12		
	End Function
End Type
